#include <stdio.h>
#include <stdlib.h>

/* This bogus `makeinfo' stand-in only creates empty files.  The output file
 * must be specified with -o<output> or -o <output>, and everything else is
 * ignored.  It is an error for no output file to be specified (it suggests
 * that there is some other "feature" we have to implement).  Also, it is an
 * error if we cannot open the output file for writing.
 * 
 * modification history
 * --------------------
 * 01a,07jul99,jld  created.
 */

int
main(int argc, char **argv) {

  char *progname = *argv;
  char *output = 0;
  FILE *ofile = 0;

  while ( *++argv ) {
    switch (**argv) {
    case '-':
      if ( *++*argv == 'o' ) {
	if ( *++*argv )
	  output = *argv;
	else
	  output = *++argv;
      }
      break;
    }
  }

  if ( ! output ) {
    fprintf(stderr, "%s: Error: no output file specified.\n", progname);
    exit(1);
  }

  if ( (ofile = fopen(output, "wb") ) ) {
    fclose(ofile);
    exit(0);
  } else {
    fprintf(stderr, "%s: Error: can't open output file, `%s'.\n", progname,
	    output);
    exit(1);
  }
}
